import { Order } from './order.entity';
export declare enum PaymentStatus {
    PENDING = "pending",
    COMPLETED = "completed",
    FAILED = "failed",
    REFUNDED = "refunded",
    CANCELLED = "cancelled",
    PAID = "paid"
}
export declare enum PaymentMethod {
    COD = "cod",
    STRIPE = "stripe",
    PAYPAL = "paypal",
    BANK_TRANSFER = "bank_transfer",
    MOBILE_PAYMENT = "mobile_payment",
    SSLCOMMERZ = "sslcommerz",
    RAZOR = "razor"
}
export declare class Payment {
    id: number;
    orderId: number;
    customerId: number;
    amount: number;
    currency: string;
    paymentMethod: PaymentMethod;
    status: PaymentStatus;
    transactionId: string;
    gatewayTransactionId: string;
    description: string;
    metadata: string;
    processedAt: Date;
    refundedAt: Date;
    refundAmount: number;
    isRefundable: boolean;
    refundReason: string;
    paymentGateway: string;
    retryCount: number;
    failureReason: string;
    createdAt: Date;
    updatedAt: Date;
    order: Order;
}
